/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.origins.mixin.forge;

import io.github.apace100.origins.component.OriginComponent;
import io.github.apace100.origins.power.ModifyPlayerSpawnPower;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.server.management.PlayerInteractionManager;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={PlayerList.class})
public class PlayerManagerMixin {
    private Tuple<ServerWorld, BlockPos> origins$respawnData = null;

    @Inject(method={"respawnPlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getOverworld()Lnet/minecraft/server/world/ServerWorld;", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void respawnPlayerHook(ServerPlayerEntity player, boolean isEnd, CallbackInfoReturnable<ServerPlayerEntity> cir, BlockPos spawnPosition, float spawnAngle, boolean isSpawnSet, ServerWorld spawnPointDimension, Optional<Vector3d> respawnPos) {
        this.origins$respawnData = null;
        if (respawnPos.isPresent() || isEnd || isSpawnSet) {
            return;
        }
        this.updatePlayerSpawn(player, false);
    }

    @ModifyVariable(method={"respawnPlayer"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;isDemo()Z", ordinal=0), ordinal=1)
    public ServerWorld updateSpawnWorld(ServerWorld world) {
        return this.origins$respawnData != null ? (ServerWorld)this.origins$respawnData.func_76341_a() : world;
    }

    @Inject(method={"respawnPlayer"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/world/ServerWorld;isSpaceEmpty(Lnet/minecraft/entity/Entity;)Z", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILHARD)
    public void updateSpawnPosition(ServerPlayerEntity player, boolean isEnd, CallbackInfoReturnable<ServerPlayerEntity> cir, BlockPos spawnPosition, float spawnAngle, boolean isSpawnSet, ServerWorld spawnPointDimension, Optional<Vector3d> respawnPos, ServerWorld respawnWorld, PlayerInteractionManager interactionManager, ServerPlayerEntity newPlayer) {
        if (this.origins$respawnData != null) {
            Vector3d pos = Vector3d.func_237491_b_((Vector3i)((Vector3i)this.origins$respawnData.func_76340_b())).func_72441_c(0.5, 0.1, 0.5);
            newPlayer.func_70012_b(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0f, 0.0f);
        }
    }

    private void updatePlayerSpawn(ServerPlayerEntity entity, boolean spawnSet) {
        for (ModifyPlayerSpawnPower power : OriginComponent.getPowers((Entity)entity, ModifyPlayerSpawnPower.class)) {
            this.origins$respawnData = power.getSpawn(spawnSet);
            if (this.origins$respawnData == null) continue;
            return;
        }
    }
}

